/**
 * Standard Hours configuration page JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    const addForm = document.getElementById('addForm');
    const editForm = document.getElementById('editForm');
    const addModal = new bootstrap.Modal(document.getElementById('addModal'));
    const editModal = new bootstrap.Modal(document.getElementById('editModal'));

    // Load available lines on page load
    loadAvailableLines();

    // Add submit handler
    document.getElementById('addSubmit').addEventListener('click', async function() {
        if (!validateForm(addForm)) return;

        const data = {
            product_series: document.getElementById('addSeries').value,
            model: document.getElementById('addModel').value,
            direct_st: document.getElementById('addDirect').value,
            indirect_st: document.getElementById('addIndirect').value,
            applicable_line: document.getElementById('addLine').value
        };

        try {
            const response = await fetch('/config/standard-hours/add', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('添加成功', 'success');
                location.reload();
            } else {
                showToast('添加失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('添加失败，请重试', 'danger');
        }
    });

    // Edit button handlers
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.getElementById('editId').value = this.dataset.id;
            document.getElementById('editSeries').value = this.dataset.series;
            document.getElementById('editModel').value = this.dataset.model;
            document.getElementById('editDirect').value = this.dataset.direct;
            document.getElementById('editIndirect').value = this.dataset.indirect;
            document.getElementById('editLine').value = this.dataset.line;
            editModal.show();
        });
    });

    // Edit submit handler
    document.getElementById('editSubmit').addEventListener('click', async function() {
        if (!validateForm(editForm)) return;

        const id = document.getElementById('editId').value;
        const data = {
            product_series: document.getElementById('editSeries').value,
            model: document.getElementById('editModel').value,
            direct_st: document.getElementById('editDirect').value,
            indirect_st: document.getElementById('editIndirect').value,
            applicable_line: document.getElementById('editLine').value
        };

        try {
            const response = await fetch(`/config/standard-hours/${id}`, {
                method: 'PUT',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('更新成功', 'success');
                location.reload();
            } else {
                showToast('更新失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('更新失败，请重试', 'danger');
        }
    });

    // Delete button handlers
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', async function() {
            const id = this.dataset.id;
            const name = this.dataset.name;

            if (!confirm(`确定要删除 "${name}" 的标准工时配置吗？`)) return;

            try {
                const response = await fetch(`/config/standard-hours/${id}`, {
                    method: 'DELETE'
                });
                const result = await response.json();

                if (result.success) {
                    showToast('删除成功', 'success');
                    location.reload();
                } else {
                    showToast('删除失败：' + (result.error || '未知错误'), 'danger');
                }
            } catch (error) {
                console.error('Error:', error);
                showToast('删除失败，请重试', 'danger');
            }
        });
    });
});

/**
 * Load available lines from department configuration
 */
async function loadAvailableLines() {
    try {
        const response = await fetch('/config/api/all-lines');
        const result = await response.json();

        if (result.success) {
            // Populate add modal dropdown
            const addLineSelect = document.getElementById('addLine');
            addLineSelect.innerHTML = '<option value="">请选择线别</option>';
            result.data.forEach(item => {
                const option = document.createElement('option');
                option.value = item.line;
                option.textContent = item.display;
                addLineSelect.appendChild(option);
            });

            // Populate edit modal dropdown
            const editLineSelect = document.getElementById('editLine');
            editLineSelect.innerHTML = '<option value="">请选择线别</option>';
            result.data.forEach(item => {
                const option = document.createElement('option');
                option.value = item.line;
                option.textContent = item.display;
                editLineSelect.appendChild(option);
            });
        }
    } catch (error) {
        console.error('Error loading lines:', error);
    }
}
