/**
 * Department configuration page JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    const addForm = document.getElementById('addForm');
    const editForm = document.getElementById('editForm');
    const addModal = new bootstrap.Modal(document.getElementById('addModal'));
    const editModal = new bootstrap.Modal(document.getElementById('editModal'));

    // Add submit handler
    document.getElementById('addSubmit').addEventListener('click', async function() {
        if (!validateForm(addForm)) return;

        const data = {
            department: document.getElementById('addDepartment').value,
            line: document.getElementById('addLine').value,
            expected_direct_manpower: document.getElementById('addDirect').value,
            expected_indirect_manpower: document.getElementById('addIndirect').value,
            normal_working_hours: document.getElementById('addHours').value
        };

        try {
            const response = await fetch('/config/department/add', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('添加成功', 'success');
                location.reload();
            } else {
                showToast('添加失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('添加失败，请重试', 'danger');
        }
    });

    // Edit button handlers
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.getElementById('editId').value = this.dataset.id;
            document.getElementById('editDepartment').value = this.dataset.department;
            document.getElementById('editLine').value = this.dataset.line;
            document.getElementById('editDirect').value = this.dataset.direct;
            document.getElementById('editIndirect').value = this.dataset.indirect;
            document.getElementById('editHours').value = this.dataset.hours;
            editModal.show();
        });
    });

    // Edit submit handler
    document.getElementById('editSubmit').addEventListener('click', async function() {
        if (!validateForm(editForm)) return;

        const id = document.getElementById('editId').value;
        const data = {
            department: document.getElementById('editDepartment').value,
            line: document.getElementById('editLine').value,
            expected_direct_manpower: document.getElementById('editDirect').value,
            expected_indirect_manpower: document.getElementById('editIndirect').value,
            normal_working_hours: document.getElementById('editHours').value
        };

        try {
            const response = await fetch(`/config/department/${id}`, {
                method: 'PUT',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('更新成功', 'success');
                location.reload();
            } else {
                showToast('更新失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('更新失败，请重试', 'danger');
        }
    });

    // Delete button handlers
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', async function() {
            const id = this.dataset.id;
            const name = this.dataset.name;

            if (!confirm(`确定要删除 "${name}" 的配置吗？`)) return;

            try {
                const response = await fetch(`/config/department/${id}`, {
                    method: 'DELETE'
                });
                const result = await response.json();

                if (result.success) {
                    showToast('删除成功', 'success');
                    location.reload();
                } else {
                    showToast('删除失败：' + (result.error || '未知错误'), 'danger');
                }
            } catch (error) {
                console.error('Error:', error);
                showToast('删除失败，请重试', 'danger');
            }
        });
    });
});
