/**
 * Abnormal Types configuration page JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    const addForm = document.getElementById('addForm');
    const editForm = document.getElementById('editForm');
    const addModal = new bootstrap.Modal(document.getElementById('addModal'));
    const editModal = new bootstrap.Modal(document.getElementById('editModal'));

    // Add submit handler
    document.getElementById('addSubmit').addEventListener('click', async function() {
        if (!validateForm(addForm)) return;

        const data = {
            name: document.getElementById('addName').value,
            description: document.getElementById('addDescription').value,
            is_active: document.getElementById('addActive').checked
        };

        try {
            const response = await fetch('/config/abnormal/add', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('添加成功', 'success');
                location.reload();
            } else {
                showToast('添加失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('添加失败，请重试', 'danger');
        }
    });

    // Edit button handlers
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.getElementById('editId').value = this.dataset.id;
            document.getElementById('editName').value = this.dataset.name;
            document.getElementById('editDescription').value = this.dataset.description;
            document.getElementById('editActive').checked = this.dataset.active === 'True';
            editModal.show();
        });
    });

    // Edit submit handler
    document.getElementById('editSubmit').addEventListener('click', async function() {
        if (!validateForm(editForm)) return;

        const id = document.getElementById('editId').value;
        const data = {
            name: document.getElementById('editName').value,
            description: document.getElementById('editDescription').value,
            is_active: document.getElementById('editActive').checked
        };

        try {
            const response = await fetch(`/config/abnormal/${id}`, {
                method: 'PUT',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await response.json();

            if (result.success) {
                showToast('更新成功', 'success');
                location.reload();
            } else {
                showToast('更新失败：' + (result.error || '未知错误'), 'danger');
            }
        } catch (error) {
            console.error('Error:', error);
            showToast('更新失败，请重试', 'danger');
        }
    });

    // Delete button handlers
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', async function() {
            const id = this.dataset.id;
            const name = this.dataset.name;

            if (!confirm(`确定要删除异常类型 "${name}" 吗？`)) return;

            try {
                const response = await fetch(`/config/abnormal/${id}`, {
                    method: 'DELETE'
                });
                const result = await response.json();

                if (result.success) {
                    showToast('删除成功', 'success');
                    location.reload();
                } else {
                    showToast('删除失败：' + (result.error || '未知错误'), 'danger');
                }
            } catch (error) {
                console.error('Error:', error);
            showToast('删除失败，请重试', 'danger');
            }
        });
    });
});
