@echo off
REM Factory Efficiency Management System - Startup Script
REM ================================================

echo.
echo ============================================
echo   Factory Efficiency Management System
echo   工厂工时效率管理系统
echo ============================================
echo.

REM Change to script directory
cd /d "%~dp0"

REM Check if Python is installed
python --version >nul 2>&1
if errorlevel 1 (
    echo Error: Python is not installed or not in PATH
    echo Please install Python 3.8 or higher
    pause
    exit /b 1
)

REM Check if virtual environment exists
if not exist "venv" (
    echo Creating virtual environment...
    python -m venv venv
)

REM Activate virtual environment
call venv\Scripts\activate.bat

REM Install dependencies if needed
if not exist "venv\Lib\site-packages\flask" (
    echo Installing dependencies...
    pip install -r requirements.txt
)

REM Initialize database if not exists
if not exist "data\efficiency.db" (
    echo Initializing database...
    python database\init_db.py
)

REM Start the server
echo.
echo Starting server...
echo Server will be available at: http://localhost:5000
echo Press Ctrl+C to stop the server
echo.
python app.py

pause
