#!/bin/bash
# Factory Efficiency Management System - Stop Script
# ================================================

echo ""
echo "============================================"
echo "  Factory Efficiency Management System"
echo "  Stopping Server..."
echo "  工厂工时效率管理系统 - 停止中..."
echo "============================================"
echo ""

# Find and kill Python processes running app.py
PIDS=$(pgrep -f "python.*app.py" 2>/dev/null)

if [ -z "$PIDS" ]; then
    echo "No running server found or already stopped."
else
    echo "Stopping server processes..."
    for PID in $PIDS; do
        kill $PID 2>/dev/null
        echo "Stopped process: $PID"
    done
    echo "Server stopped successfully."
fi
echo ""
