#!/bin/bash
# Factory Efficiency Management System - One-Click Deployment Script
# ================================================
# This script automates the deployment process
# ================================================

echo ""
echo "============================================"
echo "  Factory Efficiency Management System"
echo "  Deployment Script"
echo "  工厂工时效率管理系统 - 部署脚本"
echo "============================================"
echo ""

# Change to script directory
cd "$(dirname "$0")"

# Set project root (parent of deployment folder)
cd ..

# Detect OS
if [[ "$OSTYPE" == "darwin"* ]]; then
    OS="macOS"
elif [[ "$OSTYPE" == "linux-gnu"* ]]; then
    OS="Linux"
else
    OS="Unknown"
fi
echo "Detected OS: $OS"

echo "[1/6] Checking Python installation..."
if ! command -v python3 &> /dev/null; then
    echo "[ERROR] Python3 is not installed"
    if [[ "$OS" == "macOS" ]]; then
        echo "Install using: brew install python3"
    else
        echo "Install using: sudo apt install python3 python3-venv"
    fi
    exit 1
fi
python3 --version
echo ""

echo "[2/6] Creating virtual environment..."
if [ ! -d "venv" ]; then
    python3 -m venv venv
    echo "Virtual environment created successfully."
else
    echo "Virtual environment already exists."
fi
echo ""

echo "[3/6] Activating virtual environment..."
source venv/bin/activate
echo ""

echo "[4/6] Installing dependencies..."
echo "This may take a few minutes..."
pip install -r requirements.txt --quiet
if [ $? -ne 0 ]; then
    echo "[ERROR] Failed to install dependencies"
    exit 1
fi
echo "Dependencies installed successfully."
echo ""

echo "[5/6] Creating data directory..."
mkdir -p data
echo "Data directory ready."
echo ""

echo "[6/6] Initializing database..."
python3 -c "from app import create_tables; create_tables(); print('Database initialized successfully.')"
if [ $? -ne 0 ]; then
    echo "[WARNING] Database initialization had issues, but continuing..."
fi
echo ""

echo "============================================"
echo "  Deployment Complete!"
echo "  部署完成!"
echo "============================================"
echo ""
echo "To start the server, run: ./start.sh"
echo "Or use: python3 app.py"
echo ""
echo "Server will run at: http://localhost:5001"
echo "Default admin: username=admin, password=admin123"
echo ""
