@echo off
REM Factory Efficiency Management System - One-Click Deployment Script
REM ================================================
REM This script automates the deployment process
REM ================================================

echo.
echo ============================================
echo   Factory Efficiency Management System
echo   Deployment Script
echo   工厂工时效率管理系统 - 部署脚本
echo ============================================
echo.

REM Change to script directory (deployment folder)
cd /d "%~dp0"

REM Set project root (parent of deployment folder)
set PROJECT_ROOT=%~dp0..

REM Change to project root
cd /d "%PROJECT_ROOT%"

echo Current directory: %CD%
echo.

echo [1/6] Checking Python installation...
python --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Python is not installed or not in PATH
    echo Please install Python 3.8 or higher from: https://www.python.org
    pause
    exit /b 1
)
python --version
echo.

echo [2/6] Creating virtual environment...
if not exist "venv" (
    python -m venv venv
    echo Virtual environment created successfully.
) else (
    echo Virtual environment already exists.
)
echo.

echo [3/6] Activating virtual environment...
call venv\Scripts\activate.bat
echo.

echo [4/6] Installing dependencies...
echo This may take a few minutes...
if not exist "requirements.txt" (
    echo [ERROR] requirements.txt not found in current directory
    echo Current directory: %CD%
    pause
    exit /b 1
)
pip install -r requirements.txt
if errorlevel 1 (
    echo [ERROR] Failed to install dependencies
    pause
    exit /b 1
)
echo Dependencies installed successfully.
echo.

echo [5/6] Creating data directory...
if not exist "data" mkdir data
echo Data directory ready.
echo.

echo [6/6] Initializing database...
python -c "from app import create_tables; create_tables(); print('Database initialized successfully.')"
if errorlevel 1 (
    echo [WARNING] Database initialization had issues, but continuing...
)
echo.

echo ============================================
echo   Deployment Complete!
echo   部署完成!
echo ============================================
echo.
echo To start the server, run: deployment\start.bat
echo Or use: python app.py
echo.
echo Server will run at: http://localhost:5001
echo Default admin: username=admin, password=admin123
echo.
pause
