"""
Configuration settings for the Factory Efficiency Management System
"""
import os

# Base directory
BASE_DIR = os.path.abspath(os.path.dirname(__file__))

# Database configuration
DATA_DIR = os.path.join(BASE_DIR, 'data')
if not os.path.exists(DATA_DIR):
    os.makedirs(DATA_DIR)

SQLALCHEMY_DATABASE_URI = f'sqlite:///{os.path.join(DATA_DIR, "efficiency.db")}'
SQLALCHEMY_TRACK_MODIFICATIONS = False

# Application secret key (change in production)
SECRET_KEY = os.environ.get('SECRET_KEY') or 'dev-secret-key-change-in-production'

# Server configuration
HOST = '0.0.0.0'
PORT = 5001
DEBUG = False

# Pagination
ITEMS_PER_PAGE = 20

# Session configuration
PERMANENT_SESSION_LIFETIME = 3600  # 1 hour in seconds
